//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 36 materials and 118 primitives.
//
//  
//  Date : 06/28/2001    (28.06.2001)
//


default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.3 For Windows by Txemi Jendrix
tji@euskalnet.net  
http://home.dencity.com/tji


*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <      5.746,     -15.594,       1.138>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.83384,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         41.44055    // Vertical      23.310
  look_at   <     -3.266,       0.433,       3.614> // Following monitor
}

//    Other cameras are commented out.
/*
camera {  //  Camera Camera02
  location  <     -2.333,      -0.768,       0.317>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <     -3.850,      -0.935,       0.406> // Following Sphere019
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light_mesa
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.2855
  fade_distance  18.0
  fade_power 2.0
  translate  <0.0, -20.0, 20.0>
}


//
// ********  MATERIALS  *******
//

#include "pcbugspov.inc"

#declare Sphere003 = object {
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.025
    translate  <0.0, -0.098567, -1.923124>
  }
}

//
// ********  The bugs  *******
//

#include "toybug.inc"

#declare bug6 = union {
  object { antenas }
  object { patas }
  object { ninias }
  object { sPatchObj3 }
  object { sPatchObj4 }
  scale 0.1
  rotate 34.879971*x
  translate  <0.0, -1.492738, 3.072072>
}

#declare bugs = union {
  object { bug6 }
  object { // bug7 -> bug6
    bug6
    rotate <-20.0, -20.0, 0.0>
    translate  <1.161962, -2.140734, -0.620392>
  }
  object { // bug8 -> bug6
    bug6
    rotate <-40.0, 40.0, 0.0>
    translate  <-2.192299, -4.323924, -0.465724>
  }
  object { // bug9 -> bug6
    bug6
    rotate <-60.0, -60.0, 0.0>
    translate  <2.449799, -6.406861, 0.157679>
  }
  object { // bug10 -> bug6
    bug6
    rotate <-80.0, -40.0, 0.0>
    translate  <1.386972, -8.258927, -0.721572>
  }
  object { // bug11 -> bug6
    bug6
    // bug11 does not inherit transformations, so do 
    // inverse transformations of bug6
      translate  <0.0, 1.492738, -3.072072>
      rotate -34.879971*x
      scale 1.0/0.1
    // Now write the regular transformations of bug11
    scale 0.1
    rotate <-90.0, 0.0, -180.0>
    translate  <-2.4, -1.2, 2.5>
  }
  object { // bug12 -> bug6
    bug6
    // bug12 does not inherit transformations, so do 
    // inverse transformations of bug6
      translate  <0.0, 1.492738, -3.072072>
      rotate -34.879971*x
      scale 1.0/0.1
    // Now write the regular transformations of bug12
    scale 0.1
    rotate 90.0*x
    translate  <-2.4, -1.2, 3.3>
  }
  object { // bug13 -> bug6
    bug6
    // bug13 does not inherit transformations, so do 
    // inverse transformations of bug6
      translate  <0.0, 1.492738, -3.072072>
      rotate -34.879971*x
      scale 1.0/0.1
    // Now write the regular transformations of bug13
    scale 0.1
    rotate <-90.0, 45.0, 180.0>
    translate  <1.1, -1.2, 1.9>
  }
}
union { // buggies  
#declare bug_suelo =
  object { // bug_suelo -> bug6
    bug6
    // bug_suelo does not inherit transformations, so do 
    // inverse transformations of bug6
      translate  <0.0, 1.492738, -3.072072>
      rotate -34.879971*x
      scale 1.0/0.1
    // Now write the regular transformations of bug_suelo
    hollow
    scale 0.1
    translate  <-4.6, -4.0, 0.25>
  }
  object { bug_suelo }
  object { // tester2 -> tester1
    bug_suelo
    rotate 46.12352*z
    translate  <2.44923, 2.20922, 0.0>
  }
  object { // tester3 -> tester1
    bug_suelo
    rotate 20.0*z
    translate  <0.1, 0.8, 0.0>
  }
  object { // tester4 -> tester1
    bug_suelo
    rotate -90.0*z
    translate  <-2.5, -8.8, 0.0>
  }
  object { // tester5 -> tester1
    bug_suelo
    rotate -90.0*z
    translate  <-4.7, -5.6, 0.0>
  }
  object { // tester6 -> tester1
    bug_suelo
    rotate 138.677353*z
    translate  <-7.445525, -4.804605, 0.0>
  }
  object { // tester7 -> tester1
    bug_suelo
    rotate -45.0*z
    translate  <4.081582, -3.131452, 0.0>
  }
  object { // tester8 -> tester1
    bug_suelo
    rotate 36.060883*z
    translate  <2.755152, 2.019708, 0.0>
  }
  object { // tester9 -> tester1
    bug_suelo
    rotate 90.0*z
    translate  <-4.1, 2.2, 0.0>
  }
  object { // tester10 -> tester1
    bug_suelo
    rotate -114.928322*z
    translate  <1.058114, -10.007464, 0.0>
  }
  object { // bug_1plano -> bug6
    bug6
    // bug_1plano does not inherit transformations, so do 
    // inverse transformations of bug6
      translate  <0.0, 1.492738, -3.072072>
      rotate -34.879971*x
      scale 1.0/0.1
    // Now write the regular transformations of bug_1plano
    hollow
    scale 0.1
    rotate <-90.0, -225.0, 29.502146>
    translate  <4.229682, -14.028539, 1.6>
  }
  object { // bug14 -> bug6
    bug6
    // bug14 does not inherit transformations, so do 
    // inverse transformations of bug6
      translate  <0.0, 1.492738, -3.072072>
      rotate -34.879971*x
      scale 1.0/0.1
    // Now write the regular transformations of bug14
    scale 0.1
    rotate <90.0, 45.0, 0.0>
    translate  <2.4, -1.2, 5.2>
  }
  object { bugs }
  object { // tester20 -> tester1
    bug_suelo
    rotate 87.014236*z
    translate  <-12.485343, 4.850394, 0.0>
  }
  object { // tester19 -> tester1
    bug_suelo
    rotate 87.014236*z
    translate  <-12.570693, 3.143379, 0.0>
  }
  object { // tester18 -> tester1
    bug_suelo
    rotate -31.789104*z
    translate  <3.81665, -4.964942, 0.0>
  }
  object { // tester17 -> tester1
    bug_suelo
    rotate -47.912796*z
    translate  <2.451038, 2.887327, 0.0>
  }
  object { // tester16 -> tester1
    bug_suelo
    rotate 141.59874*z
    translate  <-9.839469, 1.777767, 0.0>
  }
  object { // tester15 -> tester1
    bug_suelo
    rotate 43.961693*z
    translate  <-5.230529, 10.739595, 0.0>
  }
  object { // tester14 -> tester1
    bug_suelo
    rotate 87.014236*z
    translate  <-9.156663, 10.312842, 0.0>
  }
  object { // tester13 -> tester1
    bug_suelo
    rotate 87.014236*z
    translate  <-9.839469, 1.777767, 0.0>
  }
  object { // tester12 -> tester1
    bug_suelo
    rotate 61.829967*z
    translate  <-6.42544, -0.014599, 0.0>
  }
  object { // tester11 -> tester1
    bug_suelo
    rotate -114.928322*z
    translate  <-2.670007, -11.195546, 0.0>
  }
  object { // tester28 -> tester1
    bug_suelo
    rotate 20.0*z
    translate  <0.59727, 4.294583, 5.7198>
  }
  object { // tester27 -> tester1
    bug_suelo
    rotate -1.697977*z
    translate  <5.65894, -1.822167, 0.0>
  }
  object { // tester26 -> tester1
    bug_suelo
    rotate -31.060369*z
    translate  <-3.057303, -1.287031, 0.0>
  }
  object { // tester25 -> tester1
    bug_suelo
    rotate 20.0*z
    translate  <-5.679471, 5.990821, 0.0>
  }
  object { // tester24 -> tester1
    bug_suelo
    rotate -132.498001*z
    translate  <-1.880004, -7.762179, 0.0>
  }
  object { // tester23 -> tester1
    bug_suelo
    rotate 58.174549*z
    translate  <-0.114054, 1.816759, 0.0>
  }
  object { // tester22 -> tester1
    bug_suelo
    rotate 20.0*z
    translate  <-1.089885, 5.029886, 2.275>
  }
  object { // tester21 -> tester1
    bug_suelo
    rotate 20.0*z
    translate  <2.551411, 2.145873, 0.0>
  }
}


//
// ********  The wall  *******
//


difference { // pared_maricas
  box { // pared
    <-1, -1, -1>, <1, 1, 1>
    material {
      pared_bug_txt
    }
    hollow
    scale <20.0, 0.5, 20.0>
    translate  <-5.0, 7.588008, 0.0>
  }
  box { // pared1
    <-1, -1, -1>, <1, 1, 1>
    material {
      pared_bug_txt
    }
    hollow
    scale <6.5, 1.0, 13.0>
    translate  <-17.8, 7.6, 3.3>
  }
}

//
// ********  The floor  *******
//


plane { // Plane001
  z,0
  material {
    suelo_txt
  }
  // All transformations fixed
  translate  -9.928614*z
}

//
// ********  The monitor  *******
//


#include "monitor.inc"

union { // monitor
  object { cuerpo_mon }
  sphere { // bola_base
    <0,0,0>,1
    scale 1.549512
    translate  <0.0, 2.324857, -1.7>
  }
  object { base_cuad }
  object { botones_ctrl }
  object { interruptor }
  object { screen }
  material {
    monitor_txt
  }
  hollow
  translate  <0.0, -1.112639, 3.88>
}

//
// ********  The table  *******
//

#declare CSG001 = union {
  sphere { // Sphere012
    <0,0,0>,1
    scale 0.25
    translate  <9.996616, 6.668411, 0.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 20.0>
    rotate -90.0*y
    translate  <10.0, -6.666666, 0.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 20.0>
    rotate -90.0*y
    translate  <10.0, 6.66667, 0.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 13.3333>
    rotate <-90.0, -90.0, 0.0>
    translate  <10.0, -6.666666, 0.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 13.33333>
    rotate <-90.0, -90.0, 0.0>
    translate  <-10.0, -6.666666, 0.0>
  }
  sphere { // Sphere013
    <0,0,0>,1
    scale 0.25
    translate  <9.996616, -6.66841, 0.0>
  }
  sphere { // Sphere014
    <0,0,0>,1
    scale 0.25
    translate  <-9.99662, 6.668411, 0.0>
  }
  sphere { // Sphere015
    <0,0,0>,1
    scale 0.25
    translate  <-9.99662, -6.66841, 0.0>
  }
  material {
    proteje_mesa_txt
  }
}
union { // mesa
  box { // mesa_up
    <-1, -1, -1>, <1, 1, 1>
    material {
      Parquet_Wood
    }
    scale <10.0, 6.666666, 0.25>
  }
  object { CSG001 }
}

//
// ********  The mouse  *******
//

#include "mouse.inc"

union { // raton
  object { sPatchObj }
  object { sPatchObj1 }
  material {
    raton_bug_txt
  }
  scale 0.8
  rotate -76.450592*z
  translate  <-3.198201, -3.240761, 0.257175>
}

//
// ********  The pen  *******
//

#declare tapon = difference {
  sphere { // Sphere016
    <0,0,0>,1
    scale <5.0, 1.0, 1.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.25, 1.25>
    translate  2.5*x
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.75>
    translate  -4.5*x
  }
  material {
    laca
  }
  scale <2.0, 1.0, 1.0>
}
#declare cuerpo = difference {
  sphere { // Sphere2
    <0,0,0>,1
    scale <5.0, 1.0, 1.0>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 1.25, 1.25>
    translate  2.5*x
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.75, 0.75>
    translate  -4.5*x
  }
  material {
    laca
  }
  scale <3.0, 1.0, 1.0>
  rotate -180.0*y
}
#declare punta_tapon = difference {
  sphere { // Sphere3
    <0,0,0>,1
    scale <5.0, 1.0, 1.0>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.25, 1.25>
    translate  1.0*x
  }
  material {
    negro
  }
  scale <2.0, 1.0, 1.0>
}
#declare cierre_cuerpo = difference {
  sphere { // Sphere4
    <0,0,0>,1
    scale <5.0, 1.0, 1.0>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 1.25, 1.25>
    translate  0.5*x
  }
  material {
    negro
  }
  scale <3.0, 1.0, 1.0>
  rotate -180.0*y
}
#declare TraSwp001 = prism {
  linear_sweep
  linear_spline
  -0.4,0.0
  14  // control points
  <-0.135737, 0.566125>,
  <-0.018712, 0.566125>,
  <0.047258, 0.787836>,
  <0.104732, 0.877336>,
  <0.220759, 0.910038>,
  <4.208099, 0.912699>,
  <4.501906, 0.700134>,
  <4.717364, 0.702123>,
  <4.861004, 0.890935>,
  <4.860448, 1.0>,
  <0.167093, 1.0>,
  <0.027466, 0.94991>,
  <-0.071635, 0.794608>,
  <-0.135737, 0.566125>
  rotate -x*90
  material {
    oro
  }
  scale <1.5, 1.0, 1.0>
  rotate 6.155465*z
  translate  <-7.864616, -0.221546, -0.2>
}
union { // pluma
  object { tapon }
  object { cuerpo }
  object { punta_tapon }
  object { cierre_cuerpo }
  torus { // cierre
    0.975, 0.175  rotate -x*90
    material {
      oro
    }
    rotate -90.0*y
  }
  torus { // cierre1
    0.975, 0.175  rotate -x*90
    material {
      oro
    }
    scale 0.6
    rotate -90.0*y
    translate  12.0*x
  }
  torus { // cierre2
    0.975, 0.175  rotate -x*90
    material {
      oro
    }
    scale 0.6
    rotate -90.0*y
    translate  -8.0*x
  }
  object { TraSwp001 }
  scale 0.08
  rotate <90.0, 2.25, 0.0>
  translate  <-0.348133, -1.4, 0.348032>
}

//
// ********  The speaker  *******
//  

#include "speaker.inc"

union { // speaker
  object { sPatchObj2 }
  object { sPatchObj5 }
  sphere { // Sphere019
    <0,0,0>,1
    material {
      encendido_txt_1
    }
    scale 0.08
    translate  <0.000505, 0.879986, -0.176378>
  }
  scale 1.1
  rotate -165.0*z
  translate  <-4.1, 0.0, 0.6>
}

//
// ********  The door  *******
//
 
#include "door.inc"

union { // lapuerta
  object { puerta }
  object { marco_puerta }
  scale <0.525, 0.535, 0.525>
  rotate -180.0*z
  translate  <-29.1, -24.8, -9.7>
}

//
// ********  The lighter  *******
//                      

#include "lighter.inc"  

//
// ********  The povray can  *******
// 

#include "can.inc"

//
// ********  The ashtray  *******
//          

#include "ashtray.inc"

//
// ********  The switch  *******
// 

#include "switch.inc"

union { // pulsador_bug
  object { pulsador }
  object { embellecedor }
  scale 0.127791
  translate  <-8.658123, 7.033486, 8.118255>
}

//
// ********  The desk lamp  *******
// 

#include "desklamp.inc"

union { // lampara
  object { bombilla }
  object { enlace }
  object { fondo_bombilla }
  object { botones }
  object { cuerpo_lamp }
  object { tulipa }
  scale 0.6
  rotate 71.17292*z
  translate  <-4.1265, -1.687112, 0.25497>
}


